# README for Advancing Rural Mobility: Michigan Public Transit Open Data Standards Program (ARMP)

Bureau of Transportation Statistics (BTS), U.S. Department of Transportation (USDOT)
2025-06-13

## Links to Dataset

Dataset Archive Link:   https://doi.org/10.21949/z23z-bb22

## Summary of Dataset

The Advancing Rural Mobility Program (ARMP) addressed this mobility data gap by developing open-standard flexible data specifications that work with demand-response services to deliver transit information in rural Michigan communities with GTFS-Flex. The GTFS-Flex extension enables the discovery of static demand-response service information, providing a more comprehensive and equitable trip-planning experience in rural areas where demand-response transit is the primary or only option. Static information equips riders with information like established service areas and hours of operation but does not include dynamic updates like real-time estimated vehicle arrival times and vehicle location information.

This dataset contains transit data specification feeds for rural agencies that were involved in the ARMP as well as supporting artifacts such as marketing materials, photos from publicity events, and survey results.

## Tables of Contents

##### A. General Information

##### B. Sharing/Access & Policies Information

##### C. Data and Related Files Overview

##### D. Methodological Information

##### E. Update Log

## A. General Information

**Title of Dataset:**  ARMP_Dataset_2025

**Description of the Dataset:** This dataset contains transit data specification feeds for rural agencies that were involved in the ARMP as well as supporting artifacts such as marketing materials, photos from publicity events, and survey results.

**Dataset Archive Link:** https://doi.org/10.21949/z23z-bb22

**Authorship Information:** 

>  *Principal Data Creator or Data Manager Contact Information*  
>  Name: Jeremy Papuga ([ORCID](https://orcid.org/0009-0007-2292-1440))   
>  Institution: HNTB
>  Address: 400 Renaissance Center Suite 1800, Detroit, MI 48243
>  Email: jpapuga@hntb.com

>  *Organizational Contact Information*  
>  Name: Janet Geissler  
>  Institution: Michigan Department of Transportation
>  Address: 1060 W Fort St, Detroit, MI 48226
>  Email: geisslerj1@michigan.gov

**Date of data collection and update interval:**

Grand awarded FY2022. Data collected from 08/15/2023 UTC 00:00:00 to 02/15/2025 UTC 23:59:59.

**Geographic location of data collection:** Michigan

**Information about funding sources that supported the collection of the data:**

 This project is funded through the U.S. Department of Transportation’s Strengthening Mobility and Revolutionizing Transportation (SMART) Grants Program, established under the Infrastructure Investment and Jobs Act

## B. Sharing/Access and Policies Information

**Recommended citation for the data:**  Michigan Department of Transportation (2025).

**Licenses/restrictions placed on the data:** This document is disseminated under the sponsorship of the U.S. Department of Transportation in the interest of information exchange. The United States Government assumes no liability for the contents thereof. To protect the privacy of subject participants and conform to the restrictions of the Institutional Review Board, raw and individual-level data will not be made available.  

**Was data derived from another source?:** No.  

This document was created to meet the requirements enumerated in the U.S. Department of Transportation's Plan to Increase Public Access to the Results of Federally-Funded Scientific Research Version 1.1(https://doi.org/10.21949/1520559) and guidelines suggested by the DOT Public Access website (https://doi.org/10.21949/1503647), in effect and current as of December 03, 2020.  

## ## C. Data and Related Files Overview

File List for the `ARMP_Dataset_2025`  

> 1. Filename: `01_ACEC_Presentation_February 2025.pdf`  
>    Short Description:  This presentation was developed for the MDOT ACEC Partnering Workshop and outlines the Advancing Rural Mobility Project's goals, implementation process, partnerships, and outcomes. This document was exported as a PDF and is 33 slides in length. The PDF is 3657 KB. 

> 2. Filename: `02_Advancing_Rural_Mobility_Website_HTML.txt`  
>    Short Description:  The website provides an overview of MDOT's efforts to enhance rural transit in Michigan, featuring project goals, implementation strategies, key outcomes, and available resources for stakeholders. The website is in an HTML format and is 111 KB.

> 3. Filename: `03_GTFS_Flex_Data_Feeds.zip`  
>    Short Description:  GTFS-Flex data files used to support the trip planning component of the project.  All files follow the accepted GTFS feed specification. This project resulted in 52,286 KB of data stored as ZIP files. These files depict the GTFS-Flex data feeds from various rural transit agencies in northern Michigan. These files include information like booking rules, calendars, directions, locations, routes, and stops from each transit agency. There are 15 folders in this ZIP file.

> 4. Filename: `04_Site_Visit_Images.zip`  
>    Short Description:  These images are from the Advancing Rural Mobility site visits and the press conference in Charlevoix, MI, in July 2024. The local transit agencies visited were WexExpress, Charlevoix County Transit, Benzie Bus, and Roscommon County Transportation Authority. There are 70 JPGs in this ZIP file. The ZIP file is 65, 091 KB. 

> 5. Filename: `05_MDOT_Advancing_Rural_Mobility_Program_Rider_Survey_Data.pdf`  
>    Short Description:  This document presents the results of a rider survey conducted as part of the MDOT Advancing Rural Mobility Program. The survey focused on how riders in rural Michigan book and use public transit services. The survey gathered insights from 65 respondents across several counties in northern Michigan. This document was exported as a PDF and is 16 pages in length. The PDF is 1044 KB. 

> 6. Filename: `06_Site_Visit_Presentation_July_2024.pdf`  
>    Short Description:  This presentation was created to guide MDOT’s site visits to four rural transit agencies as part of the Advancing Rural Mobility Project's Stage One implementation. It outlines the project’s background, goals, processes, and key case studies that inform the use of GTFS-Flex for rural transit data in Michigan. This document was exported as a PDF and is 23 slides in length. The PDF is 1233 KB. 

> 7. Filename: `07_SMART_Grant_Video_Release_July_2024.pdf`  
>    Short Description:  This is a press release dated July 2, 2024, announcing the launch of a video news release by the Michigan Department of Transportation (MDOT). It highlights the progress and impact of the Advancing Rural Mobility pilot project, funded by a federal SMART grant. This document was exported as a PDF and is two pages in length. The PDF is 149 KB.

> 8. Filename: `08_Tech_Talk_March_2025.pdf`  
>    Short Description:  This presentation outlines the pilot program led by MDOT to improve public transit accessibility and information in rural areas in Michigan through the use of GTFS-Flex, a flexible data standard for demand-response transit services. This document was exported as a PDF and is 31 slides in length. The PDF is 3742 KB.

> 9. Filename: `09_MiTripPlanner_Marketing_Kits.zip`  
>    Short Description:  There are 14 marketing kits packaged together as a ZIP file. Each marketing kit includes a press release, newsletter, flyer, and social media graphics in PDF format. The files are 247,973 KB. 
> 10. Filename: `10_MiTripPlanner_Website_Code `  
>     Short Description:  The MITripPlanner Code is the source code for the trip-planning website designed to improve access to rural transit in Michigan by integrating GTFS-Flex data for demand-response scheduling. The files are stored as a ZIP package, totaling 1.02 MB.
> 11. Filename: `11_Press_Conference_Video.mp4`  
>     Short Description: This video showcases MDOT’s announcement of the Advancing Rural Mobility pilot project with insights from transit leaders and highlights of project milestones. The video is in an interactive format (MP4 file) and is 340 MB.
> 12. Filename: `12_Advancing_Rural_Mobility_Michigan_Public_Transit_Open_Data_Standards_Program.json`  
>     Short Description: This file is the requied DCAT-US Metadata File. It is 3 KB.

## D. Methodological Information

**Description of methods used for collection/generation of data:** All PDFs and video files were generated by the project team throughout the life of the project. The GTFS feeds were generated manually based on interviews with local partner agencies and available templates. GTFS feeds were verified using the [Canonical GTFS Schedule Validator](https://gtfs-validator.mobilitydata.org/).

**Instrument or software-specific information needed to interpret the data:**

 None required.  

## E. Data-Specific Information

1. There is no data-specific information. All files are either PDFs, video files, packaged code, or GTFS files that follow a public specification.  

## E. Update Log

This README.txt file was originally created on 20250610 by Jeremy Papuga ([ORCID](https://orcid.org/0009-0007-2292-1440)), Sr. Project Manager, jpapuga@hntb.com  

20250610: : Original file created
